/* many threads can read the balance, but only one thread can change it */
#include <thread.h>
#include <synch.h>

rwlock_t account_lock;
float checking_balance = 100;
float saving_balance = 100;

float get_balance();
void transfer_checking_to_saving(float amount);


main()
{
rwlock_init(&account_lock, 0, NULL);
printf("%f", get_balance());
transfer_checking_to_saving(5);
}

float get_balance()
{
	float bal;

	rw_rdlock(&account_lock);
	bal = checking_balance + saving_balance;
	rw_unlock(&account_lock);
	return bal;
}

void transfer_checking_to_saving(float amount)
{
	rw_wrlock(&account_lock);
	checking_balance = checking_balance - amount;
	saving_balance = saving_balance + amount;
	rw_unlock(&account_lock);
}

