#include <stdio.h>
#include <unistd.h>

int main(int argc, char *argv[])
{
	int i = 0, status, fd[2];
	
	if (argc < 3) {
		fprintf(stderr, "usage: %s <command> <command>\n", argv[0]);
		exit(1);
	}

	if (pipe(fd) < 0) // create pipe
	{
		perror("pipe call");
		exit(2);
	}

	switch (fork()) 
{
		case -1: // error
			perror("fork call");
			exit(1);
		case 0: // child - the writing process
			dup2(fd[1], 1); // make stdout go to pipe
			close(fd[0]);
			close(fd[1]);
			execlp(argv[1], argv[1], NULL);
			exit(3);
		default: // parent - the reading process
			dup2(fd[0], 0); // make stdin come from pipe
			close(fd[0]);
			close(fd[1]);
			execlp(argv[2], argv[2], NULL);
			exit(3);
	}
}

