#include <signal.h>

void trap();

main()// program to illustrate a broken pipe condition
{
	int p[2];
	pid_t pid;
	char message[12];

	if (pipe(p) < 0) // open pipe
	{
		perror("pipe call");
		exit(1);
	}

	switch(pid = fork())
	{
		case -1:
			perror("fork call");
			exit(2);
		case 0: // child
			close(p[0]);
			signal(SIGPIPE, trap);
			while(write(p[1], "hello world\n", 12) > 0)
				;
			close(p[1]);
			break;
		default: // parent
			close(p[1]);
			read(p[0], message, 12);
			printf("%s\n", message);
			close(p[0]);
	}
}

void trap()
{
	printf("Got SIGPIPE signal\n");
	exit(0);
}

