#include <signal.h>

void trap();

unsigned long count = 0;

int main() // program to illustrate that the pipe is of limited size
{
	int p[2];
	char c;

	signal(SIGALRM, trap);

	if (pipe(p) < 0)
	{
		perror("pipe call");
		exit(1);
	}

	while(1)
	{
		alarm(20);
		write(p[1], &c, 1);
		alarm(0); // reset alarm
		if ( (++count % 1024) == 0)
			printf("%lu characters in pipe\n", count);
	}
}

void trap()
{
	printf("write blocked after %lu characters\n", count);
	exit(0);
}

